/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.fontengine.font.Font;
import com.adobe.internal.afml.AFMLException;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.DefaultFont;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextFormatterCompatibility;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextRegion;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;
import com.adobe.internal.pdftoolkit.services.xfatext.FormatXFAResultInfo;
import com.adobe.internal.pdftoolkit.services.xfatext.FormatXFAText;
import com.adobe.internal.pdftoolkit.services.xfatext.RegionAndAnnotInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class SimpleTextFormatterImpl
extends TextFormatterImpl {
    private double regionWidth;
    private double regionHeight;
    private double regionWidthFactorForAutosize = 1.0;
    private double regionHeightFactorForAutosize = 1.0;

    SimpleTextFormatterImpl(double regionWidth, double regionHeight) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException {
        this.regionHeight = regionHeight;
        this.regionWidth = regionWidth;
    }

    SimpleTextFormatterImpl(double regionWidth, double regionHeight, double regionWidthFactorForAutosize, double regionHeightFactorforAutosize) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException {
        this(regionWidth, regionHeight);
        this.regionWidthFactorForAutosize = regionWidthFactorForAutosize;
        this.regionHeightFactorForAutosize = regionHeightFactorforAutosize;
    }

    TextRegion getFormattedTextRegionInfo(Font psFont, PDFFontSet pdfFonts, String textString, AppearanceAttributes appearanceAttributes) throws PDFConfigurationException, PDFFontException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, AFMLException {
        FormatXFAResultInfo resultInfo = this.getFormattedTextRegion(new FormatXFAText(TextFormatterCompatibility.LATEST), psFont, pdfFonts, textString, appearanceAttributes);
        ArrayList<RegionAndAnnotInfo> regionSizes = resultInfo.getRegionSizes();
        RegionAndAnnotInfo regionInfo = null;
        if (regionSizes != null && regionSizes.size() == 1) {
            regionInfo = regionSizes.get(0);
            TextRegion textRegion = new TextRegion(regionInfo.getRight() - regionInfo.getLeft(), regionInfo.getTop() - regionInfo.getBottom());
            return textRegion;
        }
        throw new PDFInvalidDocumentException("FormatXFAText returns invalid region sizes arraylist object.");
    }

    private AppearanceAttributes fetchAppearanceAttributes(PDFFieldButton field, Locale locale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        boolean autoSize;
        PDFDefaultAppearance defAppearance = PDFVariableText.getInstance((CosObject)field.getCosObject()).getDefaultAppearance();
        if (defAppearance == null) {
            return null;
        }
        StyleAttributes defaultStyleAttr = AppearanceUtils.makeStyle(field.getPDFDocument(), null, defAppearance.asString(), 0, field.getPDFDocument().getInteractiveForm().getResources(), locale);
        boolean bl = autoSize = defaultStyleAttr.getFontSize() == 0.0;
        if (autoSize) {
            this.regionWidth *= this.regionWidthFactorForAutosize;
            this.regionHeight *= this.regionHeightFactorForAutosize;
        }
        RCGOptions options = this.getOptions();
        if (autoSize) {
            options.setOverflow(RCGOverflowMode.ShrinkToFit);
        }
        AppearanceAttributes ap = new AppearanceAttributes(defaultStyleAttr, options);
        ap.setAutoSize(autoSize);
        return ap;
    }

    private RCGOptions getOptions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        RCGOptions options = new RCGOptions(this.regionWidth, this.regionHeight);
        options.setVerticalAlignment(RCGAlignment.Middle);
        options.setWrap(RCGWrapOption.NoWrap);
        options.setOverflow(RCGOverflowMode.Auto);
        options.setPaddingAll(0.0);
        return options;
    }

    @Override
    public AppearanceAttributes fetchAppearanceAttributes(PDFAnnotation annot, PDFResources defResources, Locale locale) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException, PDFInvalidParameterException, PDFFontException {
        PDFFieldButton field = PDFFieldButton.getInstance((CosObject)annot.getCosObject());
        AppearanceAttributes appearanceAttributes = this.fetchAppearanceAttributes(field, locale);
        if (appearanceAttributes.getStyleAttributes().getFontSize() == 0.0) {
            appearanceAttributes.getStyleAttributes().setFontSize(DefaultFont.getDefaultSize(locale));
        }
        appearanceAttributes.setField((PDFField)field);
        return appearanceAttributes;
    }

    @Override
    protected FormatXFAResultInfo handleOverflow(AppearanceAttributes appearanceAttributes, PDFFontSet pdfFonts, Font psFont, PDFField field, boolean isNonComboBoxChoiceField, String textString, FormatXFAText textFormatter, RCGOptions options, StyleAttributes styleAttributes, List<String> rawOptionValuesForListBox, FormatXFAResultInfo resultInfo) {
        return resultInfo;
    }
}

