/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl.PDFDefaultAppearanceWrapper;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.BorderAppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.SimpleTextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.pdfport.PDFPort;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

abstract class RadioCheckButtonAppearanceGenerator {
    private static final double ADJUSTMENT_BELOW_BASELINE_FACTOR = 0.3;
    protected PDFDocument pdfDoc;
    protected PDFFontSet pdfFontSet;
    protected PDFResources defResources;
    protected Locale locale;
    protected String buttonDefaultStyle;
    protected boolean circularBorderForCircleStyle;
    protected boolean neutralAppearance;
    static final String BUTTON_STYLE_CIRCLE = "l";
    static final String BUTTON_STYLE_CROSS = "8";
    static final String BUTTON_STYLE_CHECK = "4";

    protected RadioCheckButtonAppearanceGenerator(APResources apResources, PDFDocument pdfDoc, PDFResources defResources) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.pdfFontSet = apResources.getSystemFonts();
        this.pdfDoc = pdfDoc;
        this.locale = apResources.getLocale();
        this.defResources = defResources;
    }

    protected void generateFieldAppearance(PDFFieldButton buttonField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontLoadingException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFConfigurationException, PDFFontException {
        int index;
        PDFAnnotationIterator buttonAnnotationIterator = buttonField.getAnnotationsIterator();
        boolean optPresent = buttonField.hasOptionList();
        int n = index = optPresent ? 0 : -1;
        while (buttonAnnotationIterator.hasNext()) {
            PDFAnnotation annot = buttonAnnotationIterator.next();
            if (annot instanceof PDFAnnotationWidget) {
                this.generateWidgetAppearance((PDFAnnotationWidget)annot, index);
            }
            if (index == -1) continue;
            ++index;
        }
    }

    protected void generateWidgetAppearance(PDFAnnotationWidget widgetAnnotation, int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFConfigurationException, PDFCosParseException, PDFFontException, FontLoadingException {
        String widgetStyle;
        PDFRectangle widgetBBox = AppearanceUtils.getBBoxRectangle(widgetAnnotation);
        PDFAppearanceCharacteristics widgetMKDict = widgetAnnotation.getAppearanceCharacteristics();
        PDFAppearance widgetAPDict = widgetAnnotation.getAppearance();
        if (widgetAPDict == null) {
            widgetAPDict = PDFAppearance.newInstance((PDFDocument)this.pdfDoc);
            widgetAnnotation.setAppearance(widgetAPDict);
        }
        ASMatrix appearanceXObjectMatrix = AppearanceUtils.getRotationMatrix(ASMatrix.createIdentityMatrix(), widgetMKDict, widgetBBox);
        String string = widgetStyle = widgetMKDict == null ? null : widgetMKDict.getNormalCaption();
        if (widgetStyle == null) {
            widgetStyle = this.buttonDefaultStyle;
        }
        this.generateWidgetONStateAppearance(widgetAnnotation, index, widgetBBox, widgetMKDict, widgetAPDict, appearanceXObjectMatrix, widgetStyle);
        if (this.neutralAppearance) {
            this.generateWidgetNeutralStateAppearance(widgetAnnotation, index, widgetBBox, widgetMKDict, widgetAPDict, appearanceXObjectMatrix, widgetStyle);
        }
        this.generateWidgetOFFStateAppearance(widgetAnnotation, widgetBBox, widgetAPDict, appearanceXObjectMatrix, this.circularBorderForCircleStyle && BUTTON_STYLE_CIRCLE.equals(widgetStyle));
    }

    private void generateWidgetONStateAppearance(PDFAnnotationWidget widgetAnnotation, int index, PDFRectangle widgetBBox, PDFAppearanceCharacteristics widgetMKDict, PDFAppearance widgetAPDict, ASMatrix appearanceXObjectMatrix, String widgetType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFConfigurationException, PDFCosParseException, PDFFontException, FontLoadingException {
        PDFXObjectForm widgetNormalONStateAppearanceXObj = PDFXObjectForm.newInstance((PDFDocument)this.pdfDoc);
        ContentWriter widgetONStateAppearanceXObjectWriter = this.generateWidgetNormalAppearance(widgetAnnotation, widgetBBox, widgetMKDict, widgetAPDict, appearanceXObjectMatrix, widgetType, this.getOnStateName(widgetAnnotation, index), widgetNormalONStateAppearanceXObj);
        Content content = widgetONStateAppearanceXObjectWriter.close();
        widgetNormalONStateAppearanceXObj.setContents(content.getContents());
    }

    private void generateWidgetNeutralStateAppearance(PDFAnnotationWidget widgetAnnotation, int index, PDFRectangle widgetBBox, PDFAppearanceCharacteristics widgetMKDict, PDFAppearance widgetAPDict, ASMatrix appearanceXObjectMatrix, String widgetType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFConfigurationException, PDFCosParseException, PDFFontException, FontLoadingException {
        PDFXObjectForm widgetNormalNeutralStateAppearanceXObj = PDFXObjectForm.newInstance((PDFDocument)this.pdfDoc);
        ContentWriter widgetNeutralStateAppearanceXObjectWriter = this.generateWidgetNormalAppearance(widgetAnnotation, widgetBBox, widgetMKDict, widgetAPDict, appearanceXObjectMatrix, widgetType, PDFFieldButton.neutralState, widgetNormalNeutralStateAppearanceXObj);
        BorderAppearanceUtils.addOpacity(widgetNeutralStateAppearanceXObjectWriter, BorderAppearanceUtils.asFixedToDouble(49152), null, false, widgetAnnotation, AppearanceUtils.getBorderWidth((PDFAnnotation)widgetAnnotation));
        Content content = widgetNeutralStateAppearanceXObjectWriter.close();
        widgetNormalNeutralStateAppearanceXObj.setContents(content.getContents());
    }

    private ContentWriter generateWidgetNormalAppearance(PDFAnnotationWidget widgetAnnotation, PDFRectangle widgetBBox, PDFAppearanceCharacteristics widgetMKDict, PDFAppearance widgetAPDict, ASMatrix appearanceXObjectMatrix, String widgetType, ASName stateName, PDFXObjectForm widgetNormalStateAppearanceXObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFConfigurationException, PDFCosParseException, PDFFontException {
        double[] fontColor;
        String DEFAULT_APPEARANCE = "/Helv 0 Tf 0 g";
        widgetNormalStateAppearanceXObj.setResources(PDFResources.newInstance((PDFDocument)this.pdfDoc));
        widgetAPDict.setNormalStateAppearance(stateName, widgetNormalStateAppearanceXObj);
        widgetNormalStateAppearanceXObj.setMatrix(appearanceXObjectMatrix.getValues());
        widgetNormalStateAppearanceXObj.setBBox(widgetBBox);
        ContentWriter widgetAppearanceXObjectWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.newInstance((PDFContents)PDFContents.newInstance((PDFDocument)this.pdfDoc), (PDFResources)widgetNormalStateAppearanceXObj.getResources()));
        PDFDefaultAppearance defAppearance = PDFVariableText.getInstance((CosObject)widgetAnnotation.getCosObject()).getDefaultAppearance();
        if (defAppearance == null) {
            PDFVariableText.getInstance((CosObject)widgetAnnotation.getCosObject()).setDefaultAppearance("/Helv 0 Tf 0 g");
            defAppearance = PDFVariableText.getInstance((CosObject)widgetAnnotation.getCosObject()).getDefaultAppearance();
        }
        if ((fontColor = new PDFDefaultAppearanceWrapper(defAppearance).getFontColor()) == null) {
            fontColor = new double[]{0.0, 0.0, 0.0};
        }
        double bWidth = AppearanceUtils.getBorderWidth((PDFAnnotation)widgetAnnotation);
        ASRectangle frClip = null;
        PDFRotation rotation = widgetMKDict == null ? PDFRotation.ROTATE_0 : widgetMKDict.getRotation();
        switch (rotation) {
            case ROTATE_0: 
            case ROTATE_180: {
                frClip = new ASRectangle(bWidth, bWidth, widgetBBox.width() - bWidth, widgetBBox.height() - bWidth);
                break;
            }
            case ROTATE_90: 
            case ROTATE_270: {
                frClip = new ASRectangle(bWidth, bWidth, widgetBBox.height() - bWidth, widgetBBox.width() - bWidth);
            }
        }
        if (widgetType.equals(BUTTON_STYLE_CROSS)) {
            BorderAppearanceUtils.writeAppearance(widgetAppearanceXObjectWriter, false, false, false, widgetAnnotation);
            BorderAppearanceUtils.drawCheck(widgetAppearanceXObjectWriter, frClip, fontColor);
        } else if (this.circularBorderForCircleStyle && widgetType.equals(BUTTON_STYLE_CIRCLE)) {
            double fxRadius = (Math.min(widgetBBox.width(), widgetBBox.height()) / 2.0 - bWidth) / 2.0;
            BorderAppearanceUtils.writeAppearance(widgetAppearanceXObjectWriter, false, true, false, widgetAnnotation);
            BorderAppearanceUtils.drawCircle(widgetBBox.width() / 2.0, widgetBBox.height() / 2.0, fxRadius, fontColor, BorderAppearanceUtils.PathOperation.FILL, widgetAppearanceXObjectWriter);
        } else {
            BorderAppearanceUtils.writeAppearance(widgetAppearanceXObjectWriter, false, false, false, widgetAnnotation);
            ContentModifier.addClippingPath((ContentWriter)widgetAppearanceXObjectWriter, (PDFRectangle)widgetNormalStateAppearanceXObj.getBBox(), (double)bWidth, (double)bWidth, (double)bWidth, (double)bWidth);
            SimpleTextFormatterImpl widgetTextFormatter = new SimpleTextFormatterImpl(widgetBBox.width(), widgetBBox.height());
            AppearanceAttributes appearanceAttributes = widgetTextFormatter.fetchAppearanceAttributes((PDFAnnotation)widgetAnnotation, this.defResources, this.locale);
            appearanceAttributes.getRcgOptions().setAdjustmentBelowBaselineFactor(0.3);
            appearanceAttributes.getRcgOptions().setVerticalAlignment(RCGAlignment.Middle);
            appearanceAttributes.getStyleAttributes().setTextAlignment(1);
            appearanceAttributes.getStyleAttributes().setDiscardLineHeightConditionality(false);
            appearanceAttributes.setTextValue(RichTextHandler.convertString2RichText(Arrays.asList(widgetType)));
            PDFPort pdfPort = new PDFPort(widgetAppearanceXObjectWriter, widgetNormalStateAppearanceXObj.getResources(), new HashMap());
            Font psFont = Base14.zapfDingbats;
            widgetTextFormatter.formatAndRenderText(appearanceAttributes, this.pdfFontSet, psFont, pdfPort);
            pdfPort.closePDFPort();
        }
        return widgetAppearanceXObjectWriter;
    }

    protected ASName getOnStateName(PDFAnnotationWidget annot, int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (index != -1) {
            return ASName.create((String)Integer.valueOf(index).toString());
        }
        ASName annotState = annot.getAppearanceState();
        if (annotState != null && annotState != PDFFieldButton.offState) {
            return annotState;
        }
        List normalAppearanceStateNames = null;
        PDFAppearance annotAppearance = annot.getAppearance();
        if (annotAppearance != null) {
            normalAppearanceStateNames = annotAppearance.getNormalAppearanceStates();
        }
        if (normalAppearanceStateNames != null) {
            for (ASName stateName : normalAppearanceStateNames) {
                if (stateName == PDFFieldButton.offState) continue;
                return stateName;
            }
        }
        return PDFFieldButton.DEFAULT_ON_STATE_NAME;
    }

    protected void generateWidgetOFFStateAppearance(PDFAnnotationWidget widgetAnnotation, PDFRectangle widgetBBox, PDFAppearance widgetAPDict, ASMatrix appearanceXObjectMatrix, boolean circularBorder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFXObjectForm widgetNormalOFFStateAppearanceXObj = PDFXObjectForm.newInstance((PDFDocument)this.pdfDoc);
        widgetNormalOFFStateAppearanceXObj.setResources(PDFResources.newInstance((PDFDocument)this.pdfDoc));
        widgetAPDict.setNormalStateAppearance(PDFFieldButton.offState, widgetNormalOFFStateAppearanceXObj);
        widgetNormalOFFStateAppearanceXObj.setMatrix(appearanceXObjectMatrix.getValues());
        widgetNormalOFFStateAppearanceXObj.setBBox(widgetBBox);
        ContentWriter buttonOffAppearanceXObjectWriter = ContentWriter.newInstance((PDFDocument)this.pdfDoc);
        BorderAppearanceUtils.writeAppearance(buttonOffAppearanceXObjectWriter, false, circularBorder, false, widgetAnnotation);
        widgetNormalOFFStateAppearanceXObj.setContents(buttonOffAppearanceXObjectWriter.close().getContents());
    }
}

