/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class StampAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationStamp> {
    private static HashMap<String, ByteArrayOutputStream> StampAPStreamCache = new HashMap();
    private static HashMap<String, String> defaultstampset = new HashMap();

    public synchronized void genAppearancePredefinedStampIcon(PDFAnnotationStamp annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException, IOException {
        double LOWERLEFT_X = 179.074997;
        double LOWERLEFT_Y = 374.062012;
        double UPPERRIGHT_X = 424.453003;
        double UPPERRIGHT_Y = 438.59198;
        InputStream newStream = null;
        InputStream stampStream = null;
        ByteArrayOutputStream outStream = null;
        PDFRectangle rect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)179.074997, (double)374.062012, (double)424.453003, (double)438.59198);
        String stampName = annot.getIconNameAsString().trim();
        if (stampName != null && !stampName.isEmpty()) {
            try {
                String resfilename = this.getresourcefilename(stampName);
                if (resfilename == null) {
                    return;
                }
                outStream = StampAPStreamCache.get(resfilename);
                if (outStream == null) {
                    byte[] b = new byte[1024];
                    int len = 0;
                    stampStream = StampAnnotApGenerator.class.getResourceAsStream(resfilename);
                    if (stampStream == null) {
                        throw new PDFIOException("Stamp Appearance Resource file not found!!");
                    }
                    outStream = new ByteArrayOutputStream();
                    while ((len = stampStream.read(b)) != -1) {
                        outStream.write(b, 0, len);
                    }
                    StampAPStreamCache.put(resfilename, outStream);
                }
                newStream = new ByteArrayInputStream(outStream.toString().getBytes());
                PDFXObjectForm xobjForm = PDFXObjectForm.newInstance((PDFDocument)annot.getPDFDocument());
                xobjForm.setStreamData(newStream);
                xobjForm.setBBox(rect);
                ASMatrix matrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -rect.left(), -rect.bottom());
                xobjForm.setMatrix(matrix.getValues());
                PDFAppearance app = PDFAppearance.newInstance((PDFDocument)annot.getPDFDocument());
                app.setNormalAppearance(xobjForm);
                annot.setAppearance(app);
            }
            catch (FileNotFoundException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            finally {
                if (newStream != null) {
                    newStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (stampStream != null) {
                    stampStream.close();
                }
            }
        } else {
            return;
        }
    }

    private String getresourcefilename(String stampName) {
        return defaultstampset.get(stampName.toLowerCase());
    }

    static {
        defaultstampset.put("approved", "Approved");
        defaultstampset.put("asis", "AsIs");
        defaultstampset.put("confidential", "Confidential");
        defaultstampset.put("departmental", "Departmental");
        defaultstampset.put("draft", "Draft");
        defaultstampset.put("experimental", "Experimental");
        defaultstampset.put("expired", "Expired");
        defaultstampset.put("final", "Final");
        defaultstampset.put("forcomment", "ForComment");
        defaultstampset.put("forpublicrelease", "ForPublicRelease");
        defaultstampset.put("notapproved", "NotApproved");
        defaultstampset.put("notforpublicrelease", "NotForPublicRelease");
        defaultstampset.put("sold", "Sold");
        defaultstampset.put("topsecret", "TopSecret");
    }
}

