/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;

class LineAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationLine> {
    LineAnnotApGenerator() {
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationLine annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        this.writer.writeGraphicsInfo((PDFAnnotation)annot, true, annot.getColor(), annot.getInteriorColor(), annot.getOpacity(), null);
        double[] coords = annot.getLineCoords();
        ASCoordinate point1 = new ASCoordinate(coords[0], coords[1]);
        ASCoordinate point2 = new ASCoordinate(coords[2], coords[3]);
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        PDFRectangle rectangle = annot.getRect();
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectangle);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        }
        PDFAnnotationLine.LineEnding[] lineEndings = annot.getLineEnds();
        double leaderLength = annot.getLeaderLength();
        double flls = leaderLength >= 0.0 ? 1.0 : -1.0;
        double leaderOffset = annot.getLeaderLineOffset() * flls;
        double leaderExtend = annot.getLeaderLineExtend() * flls;
        boolean calculateLeaders = leaderLength != 0.0 || leaderExtend != 0.0 || leaderOffset != 0.0;
        double lineLength = point1.distanceTo(point2);
        double leaderLengthOffsetH = 0.0;
        double leaderLengthOffsetV = 0.0;
        double leaderExtendOffsetH = 0.0;
        double leaderExtendOffsetV = 0.0;
        if (calculateLeaders) {
            double lineLengthV = point1.y() - point2.y();
            double lineLengthH = point1.x() - point2.x();
            double leaderOffsetH = leaderOffset * lineLengthV / lineLength;
            double leaderOffsetV = -(leaderOffset * lineLengthH / lineLength);
            leaderLengthOffsetH = leaderLength * lineLengthV / lineLength;
            leaderLengthOffsetV = -(leaderLength * lineLengthH / lineLength);
            leaderExtendOffsetH = leaderExtend * lineLengthV / lineLength;
            leaderExtendOffsetV = -(leaderExtend * lineLengthH / lineLength);
            point1.translate(leaderLengthOffsetH + leaderOffsetH, 0.0);
            point1.translate(0.0, leaderLengthOffsetV + leaderOffsetV);
            point2.translate(leaderLengthOffsetH + leaderOffsetH, 0.0);
            point2.translate(0.0, leaderLengthOffsetV + leaderOffsetV);
        }
        boolean backOffBegin = this.backOffLineForArrowHead(lineEndings[0]);
        boolean backOffEnd = this.backOffLineForArrowHead(lineEndings[1]);
        if (backOffBegin || backOffEnd) {
            double borderWidth = this.writer.lineWidth;
            lineLength = point1.distanceTo(point2);
            if (lineLength > 0.0) {
                double lineLengthV;
                double dV;
                double lineLengthH = point2.x() - point1.x();
                double dH = borderWidth * lineLengthH / lineLength;
                if (dH <= lineLengthH) {
                    if (backOffBegin) {
                        point1 = point1.translate(dH, 0.0);
                    }
                    if (backOffEnd) {
                        point2 = point2.translate(-dH, 0.0);
                    }
                }
                if ((dV = borderWidth * (lineLengthV = point2.y() - point1.y()) / lineLength) <= lineLengthV) {
                    if (backOffBegin) {
                        point1 = point1.translate(0.0, dV);
                    }
                    if (backOffEnd) {
                        point2 = point2.translate(0.0, -dV);
                    }
                }
            }
        }
        this.writer.moveTo(point1.x(), point1.y());
        this.writer.lineTo(point2.x(), point2.y());
        this.writer.fillStroke(false, this.writer.stroke);
        ASCoordinate[] fxPoints = new ASCoordinate[2];
        boolean bReverse = false;
        if (lineEndings[0] != null) {
            fxPoints[0] = point1;
            fxPoints[1] = point2;
            this.writer.drawLineEnding(this.writer.lineWidth, fxPoints, lineEndings[0], bReverse);
        }
        if (lineEndings[1] != null) {
            fxPoints[0] = point2;
            fxPoints[1] = point1;
            this.writer.drawLineEnding(this.writer.lineWidth, fxPoints, lineEndings[1], bReverse);
        }
        if (leaderLength != 0.0 || leaderExtend != 0.0) {
            this.writer.moveTo(point1.x() + leaderExtendOffsetH, point1.y() + leaderExtendOffsetV);
            this.writer.lineTo(point1.x() - leaderLengthOffsetH, point1.y() - leaderLengthOffsetV);
            this.writer.fillStroke(false, this.writer.stroke);
            this.writer.moveTo(point2.x() + leaderExtendOffsetH, point2.y() + leaderExtendOffsetV);
            this.writer.lineTo(point2.x() - leaderLengthOffsetH, point2.y() - leaderLengthOffsetV);
            this.writer.fillStroke(false, this.writer.stroke);
        }
        ASRectangle fr = new ASRectangle(this.writer.adjustedBBox[0] - 5.0, this.writer.adjustedBBox[1] - 5.0, this.writer.adjustedBBox[2] + 5.0, this.writer.adjustedBBox[3] + 5.0);
        this.writer.adjustedBBox = fr.getValues();
        this.setRect(annot, PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (ASRectangle)fr), null);
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (ASRectangle)fr), annot.getPage().getCropBox());
        } else {
            this.setRect(annot, PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (ASRectangle)fr), null);
            this.createAndSetAppearance(annot, PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (ASRectangle)fr));
        }
    }
}

