/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderEffects;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.CloudUtils;
import java.util.Iterator;
import java.util.List;

class CircleAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationCircle> {
    CircleAnnotApGenerator() {
    }

    @Override
    public void generateAppearanceInternal(PDFAnnotationCircle annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        PDFRectangle rectOrig = this.getRect((PDFAnnotation)annot, annot.getFringe());
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectOrig);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix((double)fm.geta(), (double)fm.getb(), (double)fm.getc(), (double)fm.getd(), (double)fm.getx(), (double)fm.gety()));
        }
        this.writer.writeGraphicsInfo((PDFAnnotation)annot, true, annot.getColor(), annot.getInteriorColor(), annot.getOpacity(), null);
        PDFRectangle rect = rectOrig;
        rect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)(rectOrig.left() + this.writer.lineWidth / 2.0), (double)(rectOrig.bottom() + this.writer.lineWidth / 2.0), (double)(rectOrig.right() - this.writer.lineWidth / 2.0), (double)(rectOrig.top() - this.writer.lineWidth / 2.0));
        PDFBorderEffects borderEffects = annot.getBorderEffects();
        double cloudIntensity = borderEffects != null ? borderEffects.getIntensity() : 0.0;
        ASName style = borderEffects != null ? borderEffects.getStyle() : ASName.k_S;
        int nClouds = 0;
        if (style == ASName.k_C && cloudIntensity > 0.0) {
            double a = rectOrig.height() / 2.0;
            double b = rectOrig.width() / 2.0;
            double perimeter = Math.PI * (3.0 * (a + b) - Math.sqrt((3.0 * a + b) * (a + 3.0 * b)));
            nClouds = CloudUtils.calculateCloudsPerLength(cloudIntensity, perimeter, this.writer.lineWidth);
        }
        if (nClouds < 2) {
            this.writer.writeEllipse(rect.left(), rect.bottom(), rect.width(), rect.height());
            this.writer.fillStroke(this.writer.fill, this.writer.stroke);
        } else {
            double dx = (rect.left() + rect.right()) / 2.0;
            double dy = (rect.bottom() + rect.top()) / 2.0;
            List<AnnotationAppearanceGenerator.Arc> vArc = CloudUtils.cloudify((rect.right() - rect.left()) / 2.0, (rect.top() - rect.bottom()) / 2.0, nClouds, 0.6);
            Iterator<AnnotationAppearanceGenerator.Arc> itr = vArc.iterator();
            AnnotationAppearanceGenerator.Arc arc = null;
            boolean first = true;
            while (itr.hasNext()) {
                arc = itr.next();
                this.writer.arcto(arc.m_center.x() + dx, arc.m_center.y() + dy, arc.m_radius, arc.t2 - 0.39269908169872414, arc.t1, true, first);
                this.writer.arcto(arc.m_center.x() + dx, arc.m_center.y() + dy, arc.m_radius, arc.t2 - 0.39269908169872414, arc.t2, false, false);
                first = false;
            }
            this.writer.contentWriter.write(InstructionFactory.newClosePath());
            this.writer.fillStroke(this.writer.fill, this.writer.stroke);
        }
        PDFRectangle rectAfter = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, rectAfter, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rectOrig, rectAfter);
            this.createAndSetAppearance(annot, rectAfter);
        }
    }
}

