/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.integrations.ajo.servlets;

import com.adobe.aem.integrations.ajo.AjoException;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/bin/ajo/resolveUrls"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-7041)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class UrlResolverServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(UrlResolverServlet.class);
    public static final String URL_PARAM = "url";
    private final transient Externalizer externalizer;

    @Activate
    public UrlResolverServlet(@Reference Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            log.debug("Resolving urls...");
            ResourceResolver resourceResolver = request.getResourceResolver();
            String[] urls = request.getParameterValues(URL_PARAM);
            if (urls == null || urls.length == 0) {
                throw new AjoException("Missing parameter: url");
            }
            JSONObject payload = new JSONObject();
            for (String url : urls) {
                String externalUrl = this.externalizer.externalLink(resourceResolver, "publish", url);
                log.debug("Resolved url {} to {}", (Object)url, (Object)externalUrl);
                payload.put(url, (Object)externalUrl);
            }
            response.setContentType("application/json");
            response.getWriter().write(payload.toString());
        }
        catch (Exception e) {
            throw new ServletException("Error while resolving urls", (Throwable)e);
        }
    }
}

