/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.integrations.ajo.servlets;

import com.adobe.aem.integrations.ajo.AjoConfiguration;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.paths=/bin/ajo/frontend"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-7041)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
@Designate(ocd=AjoConfiguration.class)
public class FrontendServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(FrontendServlet.class);
    public static final String FRONTEND_ULR = "https://experience.adobe.com/aem-outbound-marketing";
    public static final String AEM_URL_PARAM = "aem";
    private final AjoConfiguration configuration;

    @Activate
    public FrontendServlet(@Reference(cardinality=ReferenceCardinality.OPTIONAL) AjoConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        log.debug("Redirecting to frontend application...");
        String redirectUrl = this.getRedirectUrl(request);
        log.debug("Redirect URL: {}", (Object)redirectUrl);
        response.sendRedirect(redirectUrl);
    }

    private String getRedirectUrl(SlingHttpServletRequest request) {
        return this.getFrontendUrl() + "/?aem=" + this.getInstanceUrl(request);
    }

    private String getFrontendUrl() {
        return this.configuration != null ? this.configuration.frontendUrl() : FRONTEND_ULR;
    }

    private String getInstanceUrl(SlingHttpServletRequest request) {
        if (this.configuration != null && StringUtils.isNotBlank((String)this.configuration.instanceUrl())) {
            return this.configuration.instanceUrl();
        }
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    }
}

