/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.owasp.html.Encoding;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlToken;
import org.owasp.html.HtmlTokenType;
import org.owasp.html.TCB;
import org.owasp.html.TagBalancingHtmlStreamEventReceiver;
import slingxss.com.google.common.collect.Lists;

public final class HtmlSanitizer {
    public static void sanitize(@Nullable String html, Policy policy) {
        HtmlSanitizer.sanitize(html, policy, HtmlStreamEventProcessor.Processors.IDENTITY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void sanitize(@Nullable String html, Policy policy, HtmlStreamEventProcessor preprocessor) {
        String htmlContent = html != null ? html : "";
        HtmlStreamEventReceiver receiver = HtmlSanitizer.initializePolicy(policy, preprocessor);
        receiver.openDocument();
        HtmlLexer lexer = new HtmlLexer(htmlContent);
        LinkedList<String> attrs = Lists.newLinkedList();
        block10: while (true) {
            if (!lexer.hasNext()) {
                receiver.closeDocument();
                return;
            }
            HtmlToken token = lexer.next();
            switch (token.type) {
                case TEXT: {
                    receiver.text(Encoding.decodeHtml(htmlContent.substring(token.start, token.end), false));
                    break;
                }
                case UNESCAPED: {
                    receiver.text(Encoding.stripBannedCodeunits(htmlContent.substring(token.start, token.end)));
                    break;
                }
                case TAGBEGIN: {
                    if (htmlContent.charAt(token.start + 1) == '/') {
                        receiver.closeTag(HtmlLexer.canonicalElementName(htmlContent.substring(token.start + 2, token.end)));
                        while (lexer.hasNext() && lexer.next().type != HtmlTokenType.TAGEND) {
                        }
                        continue block10;
                    } else {
                        attrs.clear();
                        boolean attrsReadyForName = true;
                        block12: while (lexer.hasNext()) {
                            HtmlToken tagBodyToken = lexer.next();
                            switch (tagBodyToken.type) {
                                case ATTRNAME: {
                                    if (!attrsReadyForName) {
                                        attrs.add((String)attrs.getLast());
                                    } else {
                                        attrsReadyForName = false;
                                    }
                                    attrs.add(HtmlLexer.canonicalAttributeName(htmlContent.substring(tagBodyToken.start, tagBodyToken.end)));
                                    break;
                                }
                                case ATTRVALUE: {
                                    String attributeContentRaw = HtmlSanitizer.stripQuotes(htmlContent.substring(tagBodyToken.start, tagBodyToken.end));
                                    attrs.add(Encoding.decodeHtml(attributeContentRaw, true));
                                    attrsReadyForName = true;
                                    break;
                                }
                                case TAGEND: {
                                    break block12;
                                }
                            }
                        }
                        if (!attrsReadyForName) {
                            attrs.add((String)attrs.getLast());
                        }
                        receiver.openTag(HtmlLexer.canonicalElementName(htmlContent.substring(token.start + 1, token.end)), attrs);
                        continue block10;
                    }
                }
            }
        }
    }

    private static String stripQuotes(String encodedAttributeValue) {
        char last;
        int n = encodedAttributeValue.length();
        if (n > 0 && ((last = encodedAttributeValue.charAt(n - 1)) == '\"' || last == '\'')) {
            int start = 0;
            if (n != 1 && last == encodedAttributeValue.charAt(0)) {
                start = 1;
            }
            return encodedAttributeValue.substring(start, n - 1);
        }
        return encodedAttributeValue;
    }

    private static HtmlStreamEventReceiver initializePolicy(Policy policy, HtmlStreamEventProcessor preprocessor) {
        TagBalancingHtmlStreamEventReceiver balancer = new TagBalancingHtmlStreamEventReceiver(policy);
        balancer.setNestingLimit(256);
        return preprocessor.wrap(balancer);
    }

    @TCB
    public static interface Policy
    extends HtmlStreamEventReceiver {
        @Override
        public void openTag(String var1, List<String> var2);

        @Override
        public void closeTag(String var1);

        @Override
        public void text(String var1);
    }
}

